create or replace package body tbicds.PCK_COMMON is

  /* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  /*****
  helper function used to get age given date of birth
  *****/
  function GetAge(pi_dtDOB in date) return number 
  is
    v_nAge number;
  begin
    v_nAge := trunc(months_between(sysdate, pi_dtDOB) / 12);
    return v_nAge;
  end;

  /*
  get a piece of data from a string given the delimeter and position
  */
  function GetPiece(strData      in varchar2,
                    strDelimiter in varchar2,
                    nPosition    in NUMBER) return varchar2 
  is
  
    strWorking varchar2(4000);
    strPiece   varchar2(400);
    pos        number;
    nPos2      number;
    nCount     number;
  begin
    --the piece to return
    strPiece := '';
  
    --set working to data
    strWorking := strData;
  
    --put a delimeter on the front for parsing if needed
    if substr(strWorking, 1, 1) != strDelimiter then
      strWorking := strDelimiter || strWorking;
    end if;
  
    --put a delimeter on the end
    strWorking := strWorking || strDelimiter;
  
    --find the piece between the ~'s ie... "~piece~"
    pos    := -1;
    nCount := -1;
    while (pos != 0) loop
      pos := instr(strWorking, strDelimiter);
      if pos != 0 then
        --increment count
        nCount := nCount + 1;
        --found the piece...
        if nCount = nPosition then
          if (pos + 1 > length(strWorking) - 1) then
            --nothing
            strPiece := '';
          else
            strWorking := substr(strWorking, pos + 1);
            nPos2      := instr(strWorking, strDelimiter);
            if nPos2 = 0 then
              --last piece
              strPiece := strWorking;
              return ltrim(rtrim(strPiece));
            else
              strPiece := substr(strWorking, 0, nPos2 - 1);
              return ltrim(rtrim(strPiece));
            end if;
          end if;
        else
          strWorking := substr(strWorking, pos + 1);
        end if;
      end if;
    end loop;
  
    return ltrim(rtrim(strPiece));
  
  exception
    when others then
      return '';
  end GetPiece;

  /*join data together by delimeter and return*/ 
  function join(p_cursor sys_refcursor, p_del varchar2 := ',')
    return varchar2 
  is
    l_value  varchar2(32767);
    l_result varchar2(32767);
  begin
    loop
      fetch p_cursor into l_value;
      exit when p_cursor%notfound;
      if l_result is not null then
        l_result := l_result || p_del;
      end if;
      l_result := l_result || l_value;
    end loop;
    return l_result;
  end join;

end;
/

